<?php
use Smarty\Template;

function fix_global_html_output(string $tpl_output, Smarty\Template $template): string
{
    // 1. Promote the first <h2> or <h3> + matching </h2> or </h3> into <h1>...</h1>
    $tpl_output = preg_replace_callback('/<(h2|h3)([^>]*)>(.*?)<\/\1>/is', function ($match) {
        return '<h1' . $match[2] . '>' . $match[3] . '</h1>';
    }, $tpl_output, 1); // Only first match

    // 2. Fix <img> tags: add alt/title if missing
    $tpl_output = preg_replace_callback('/<img\s+([^>]*?)>/i', function ($match) {
        $attrs = $match[1];
        $src = '';

        if (preg_match('/src="([^"]+)"/i', $attrs, $srcMatch)) {
            $src = $srcMatch[1];
        }

        $src_path = parse_url($src, PHP_URL_PATH) ?? '';
        $filename = $src_path ? basename($src_path) : 'image';
        $label = ucwords(preg_replace(['/[_\-]+/', '/\.(jpg|jpeg|png|webp|gif)$/i'], [' ', ''], $filename));

        if (!preg_match('/alt\s*=/i', $attrs)) {
            $attrs = 'alt="' . $label . '" ' . $attrs;
        } elseif (preg_match('/alt\s*=\s*""/', $attrs)) {
            $attrs = preg_replace('/alt\s*=\s*""/', 'alt="' . $label . '"', $attrs);
        }

        if (!preg_match('/title\s*=/i', $attrs)) {
            $attrs = 'title="' . $label . '" ' . $attrs;
        } elseif (preg_match('/title\s*=\s*""/', $attrs)) {
            $attrs = preg_replace('/title\s*=\s*""/', 'title="' . $label . '"', $attrs);
        }

        return '<img ' . trim($attrs) . '>';
    }, $tpl_output);

    // 3. Fix <a> tags: add title if missing
    $tpl_output = preg_replace_callback('/<a\s+([^>]*?)>(.*?)<\/a>/is', function ($match) {
        $attrs = $match[1];
        $text  = trim(strip_tags($match[2]));

        $label = $text ?: 'Link';

        if (preg_match('/href="([^"]+)"/i', $attrs, $hrefMatch) && !$text) {
            $href_path = parse_url($hrefMatch[1], PHP_URL_PATH) ?? '';
            $label = $href_path ? basename($href_path) : 'Link';
        }

        if (!preg_match('/title\s*=/i', $attrs)) {
            $attrs = 'title="' . htmlspecialchars($label, ENT_QUOTES) . '" ' . $attrs;
        }

        return '<a ' . trim($attrs) . '>' . $match[2] . '</a>';
    }, $tpl_output);

    return $tpl_output;
}
?>
